﻿Object.prototype.initializeBaseType = function (baseType, args) {
  if (arguments.length > 1) {
    baseType.apply(this, args);
  }
  else {
    baseType.call(this);
  }
}

Book = function (publisher, subject, publishYear) {
  this.publisher = publisher;
  this.subject = subject;

  var publishYear = publishYear;
  WasPublishedThisYear = function() {
    var currdate = new Date();
    return (currdate.getFullYear() === publishYear);
  }
}

Book.prototype.IsSubjectDotNet = function() {
  return (this.subject.indexOf('NET') !== -1);
}

Book.prototype.IsBookNewAndCool = function() {
  return (WasPublishedThisYear() && this.IsSubjectDotNet ()); 
}

Book.prototype.toArray = function() {
  return [this.publisher, this.subject];
}

TextBook = function(publisher, subject, publishYear, gradeLevel) {
  this.gradeLevel = gradeLevel;
  this.initializeBaseType (Book, [ publisher, subject, publishYear, gradeLevel ]);
}

var myTextBook = new TextBook("A&W", "ASP.NET AJAX", 2007, 11);
alert (myTextBook.publisher);
alert (myTextBook.gradeLevel);
